//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for Hewlett-Packard Notebooks
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//   Author: Mateusz Ludwin
//   This Files are written by Henry100 (the Information by Mateusz Ludwin!)
//
//  Last Update: 27 September 2006 
//
public static class COMPAQ
{
    #region Notebook N620c : class N620c
    //
    // class author: Henry100
    //
    public static class N620c
    {
        #region Class for HP N620c FAN control : class FAN
        //
        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F0");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F0");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F0");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off
                        // Second package
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1F2", "PKG[0].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1F0");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion
        //
        #endregion
    }

    #endregion
    //no fan-speed

    #region Notebook N410c : class N410c
    //
    // class author: Henry100
    //
    public static class N410c
    {

        #region Class for Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Notebook FAN-LEVEL Control";
            public const bool default_enabled = true;
            public const int icon = 2;

            #region Value class for FAN_THERMAL_RANGE1 : class FAN_THERMAL_RANGE1
            //
            public static class FAN_THERMAL_RANGE1
            {
                // Properties of the value class
                public const string description = "FAN ON low level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range1 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 65;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[1].PKG[0]", fan_thermal_range1 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[0].PKG[1]", (fan_thermal_range1 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1C7");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE2 : class FAN_THERMAL_RANGE2
            //
            public static class FAN_THERMAL_RANGE2
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range2 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 75;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[1].PKG[1]", fan_thermal_range2 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[0].PKG[2]", (fan_thermal_range2 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1C7");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE3 : class FAN_THERMAL_RANGE3
            //
            public static class FAN_THERMAL_RANGE3
            {
                // Properties of the value class
                public const string description = "FAN ON high level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range3 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[1].PKG[2]", fan_thermal_range3 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[0].PKG[3]", (fan_thermal_range3 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1C7");

                    }
                }
            }
            //
            #endregion

            #region Value class for FAN_THERMAL_RANGE4 : class FAN_THERMAL_RANGE4
            //
            public static class FAN_THERMAL_RANGE4
            {
                // Properties of the value class
                public const string description = "FAN ON maximum level";
                public const bool nhc_visible = true;

                // Value
                public static int fan_thermal_range4 = 50;		// Upper limit
                public const string unit = "°C";

                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;
                    public const int nhc_minimum_value = 30;
                    public const int nhc_maximum_value = 80;
                    public const int nhc_default_value = 50;
                    public const int base_level = 2732;			// Bias for K to C conversion
                    public const int range = 5;
                    public static bool nhc_on_write()
                    {

                        // First package (AFAIK these two lines are enough)
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[1].PKG[3]", fan_thermal_range4 * 10 + base_level); // on
                        ACPI.PACKAGE.Write("_TZ.C1C9", "PKG[1].PKG[0].PKG[4]", (fan_thermal_range4 - range) * 10 + base_level); // off

                        return ACPI.METHOD.Call("_TZ.C1C7");

                    }
                }
            }
            //
            #endregion
        }
        //
        #endregion

    }
    #endregion
}


